package drools;


import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

import jade.core.Agent;

import java.io.*;
import ontologias.frutasOntology.*;

public class motorDrools {

    public void insertarHecho(Fruta f, int tipoAgente) {
        try {
            //Cargamos la base de reglas

            RuleBase ruleBase = leerReglas(tipoAgente);

            WorkingMemory workingMemory = ruleBase.newStatefulSession();

                        
            //Cargamos el/los objetos a validar
            workingMemory.insert(f);



            //Disparamos las reglas de Drools
            workingMemory.fireAllRules();


        } catch (Throwable t) {
        	System.out.println(t.getMessage());
        }
    }

    private static RuleBase leerReglas(int tipoAgente) throws Exception {
        //Construimos un paquete de reglas
        PackageBuilder builder = new PackageBuilder();
        Reader source = null;

        //Leemos, parseamos y compilamos las reglas
        switch (tipoAgente) {
            case 0: // Agente Comprador
                source = new InputStreamReader(new FileInputStream("./src/drools/reglasComprador.drl"));
                break;
            case 1: // Agente Vendedor
                source = new InputStreamReader(new FileInputStream("./src/drools/reglasVendedor.drl"));
                break;
        }
        Reader dsl = new InputStreamReader(motorDrools.class.getResourceAsStream("reglas.dsl"));
        builder.addPackageFromDrl(source, dsl);

        // Verificamos el builder para ver si hubo errores
        if (builder.hasErrors()) {
            System.out.println(builder.getErrors().toString());
            throw new RuntimeException("No se pudo compilar el archivo de reglas.");
        }

        //Obtenemos el package de reglas compilado
        Package pkg = builder.getPackage();

        //Agregamos el paquete a la base de reglas
        //(desplegamos el paquete de reglas).
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);

        return ruleBase;

    }
}
